--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- niGeometryData objects contain the geometry data necessary to render a niGeometry object. When a niGeometry-based object is created, the actual geometry data is stored in an attached niGeometryData object.
--- 
--- The distinction between niGeometry and niGeometryData (and other pairs of NetImmerse classes with similarly distinguished names, such as niTriShape and niTriShapeData) is that niGeometry stores data that cannot be shared when an object is instanced, and niGeometryData stores data that can be shared when an object is instanced. So, for example, when a scene graph is cloned, duplicate copies of the niGeometry objects in the original scene graph are created for the new scene graph, but new niGeometryData objects are not created. Instead, the newly-created niGeometry objects refer to the same niGeometryData objects referred to by the original scene graph.
--- @class niGeometryData : niObject
--- @field activeVertices tes3vector3[] *Read-only*. The array of active vertex position data. The length of the array is equal to `vertexCount`.
--- @field bounds niBound The model-space bounding sphere of the object.
--- @field colors niPackedColor[] *Read-only*. The vertex colors for the object. The length of the array is equal to `vertexCount`.
--- @field normals tes3vector3[] *Read-only*. The list of unitized, model-space vertex normals for the object. The length of the array is equal to `vertexCount`.
--- @field texCoords tes3vector2[] *Read-only*. The array of texture coordinates. The length of the array is equal to `vertexCount` times `textureSets`.
--- @field textures tes3vector2[] *Read-only*. The array of texture coordinates. The length of the array is equal to `vertexCount` times `textureSets`.
--- @field textureSets number The number of texture coordinate sets in the data.
--- @field uniqueID number *Read-only*. A unique ID for this model, assigned at model creation.
--- @field vertexCount number *Read-only*. The vertex count for the object.
--- @field vertices tes3vector3[] *Read-only*. The array of vertex position data. The length of the array is equal to `vertexCount`.
niGeometryData = {}

--- Tells the renderer that the object has changed. Should be called after you have finished changing any vertex data.
--- 
--- If you have altered vertex positions, you may need to also call `updateModelBound`. You should call it if vertices have been moved outside the bounds of the original model.
function niGeometryData:markAsChanged() end

--- Updates the geometry bounds to match the vertex data. You should call it if vertices have been moved outside the bounds of the original model, or if the effective bounds have become significantly smaller. 
--- 
--- If you already know the effective radius of the vertex data, you could more efficiently set the bounds directly instead of calling this function.
function niGeometryData:updateModelBound() end

